$token=$args[0]
$productcode=$args[1]
$zipfile=$args[2]
$downloadfolder=$args[3]

function GetUnit($totalbytes, [ref]$theunit, [ref]$divideby)
{
	$GB = 1073741824
	$MB = 1048576
	$KB = 1024
	
	if ($totalbytes -ge $GB)
	{
		$theunit.Value = "GB"
		$divideby.Value = $GB
	}
	elseif ($totalbytes -ge $MB)
	{
		$theunit.Value = "MB"
		$divideby.Value = $MB
	}
	elseif ($totalbytes -ge $KB)
	{
		$theunit.Value = "KB"
		$divideby.Value = $KB
	}
	else
	{
		$theunit.Value = "B"
		$divideby.Value = 1
	}
}

function GetDurationString($millisec)
{
	$myresult = ""
	$tmp = $millisec % 1000
	$sec = ($millisec - $tmp) / 1000
	$millisec = $tmp
	
	$tmp = $sec % 60
	$min = ($sec - $tmp) / 60
	$sec = $tmp
	
	$tmp = $min % 60
	$hr = ($min - $tmp) / 60
	$min = $tmp
	
	$tmp = $hr % 24
	$day = ($hr - $tmp) / 24
	$hr = $tmp
	
	if ($day -gt 0)
	{
		$myresult = $myresult + " $day d"
	}
	if ($hr -gt 0)
	{
		$myresult = $myresult + " $hr hr"
	}
	if ($min -gt 0)
	{
		$myresult = $myresult + " $min min"
	}
	if ($sec -gt 0)
	{
		$myresult = $myresult + " $sec sec"
	}
	
	return $myresult
}

$url = "http://www.ip2location.com/download?token=" + $token + "&file=" + $productcode
$saveto = $downloadfolder + "\" + $zipfile

$dest = $saveto

$uri = New-Object "System.Uri" "$url"
$request = [System.Net.HttpWebRequest]::Create($uri)
$request.set_Timeout(30000)
$response = $request.GetResponse()
$length = $response.get_ContentLength()
$responseStream = $response.GetResponseStream()
$destStream = New-Object -TypeName System.IO.FileStream -ArgumentList $dest, Create
$buffer = New-Object byte[] 10KB
$count = $responseStream.Read($buffer, 0, $buffer.length)
$downloadedBytes = $count
$unitA = ""
$unitB = ""
$unitC = ""
$dividebyA = 1
$dividebyB = 1
$dividebyC = 1
GetUnit $length ([ref]$unitA) ([ref]$dividebyA)
$totalLength = [System.Math]::Floor($length / $dividebyA)

$oldtime = $(get-date)
$oldsize = $downloadedBytes
$newtime = 0
$newsize = 0
$speed = 0

$timer = new-object timers.timer 
$timer.Interval = 2000
$timer.Enabled = $true
$timer.AutoReset = $true
$complete = 0

$action = {
	if ($global:complete -eq 1)
	{
		$timer.stop()
		Unregister-Event thetimer
	}
	else
	{
		$global:newtime = $(get-date)
		$global:newsize = $global:downloadedBytes
		
		$bytesincrement = $global:newsize - $global:oldsize
		$timeincrement = $global:newtime - $global:oldtime
		
		$global:speed = [System.Math]::Round($bytesincrement / $timeincrement.TotalSeconds, 2)
		
		$global:oldtime = $global:newtime
		$global:oldsize = $global:newsize
	}
}
$stuff = Register-ObjectEvent -InputObject $timer -SourceIdentifier thetimer -EventName Elapsed -Action $action

while ($count -gt 0)
{
	GetUnit $downloadedBytes ([ref]$unitB) ([ref]$dividebyB)
	[System.Console]::CursorLeft = 0
	if ($speed -eq 0)
	{
		[System.Console]::Write("Downloaded: {0}{3} of {1}{4} ({2}%)                                                                     ", [System.Math]::Floor($downloadedBytes / $dividebyB), $totalLength, [System.Math]::Round(($downloadedBytes / $length) * 100,0), $unitB, $unitA)
	}
	else
	{
		GetUnit $speed ([ref]$unitC) ([ref]$dividebyC)
		$bytesleft = $length - $downloadedBytes
		$timeleft = ($bytesleft / $speed) * 1000
		$timeleft = GetDurationString $timeleft
		[System.Console]::Write("Downloaded: {0}{3} of {1}{4} ({2}%) Estimated time left: {5} at {6}{7}/s                                ", [System.Math]::Floor($downloadedBytes / $dividebyB), $totalLength, [System.Math]::Round(($downloadedBytes / $length) * 100,0), $unitB, $unitA, $timeleft, [System.Math]::Round($speed / $dividebyC, 2), $unitC)
	}
	$destStream.Write($buffer, 0, $count)
	$count = $responseStream.Read($buffer,0,$buffer.length)
	$downloadedBytes+=$count
}
$complete = 1
[System.Console]::CursorLeft = 0
[System.Console]::Write("                                                                                                                 ")
[System.Console]::CursorLeft = 0

$destStream.Flush()
$destStream.Close()
$destStream.Dispose()
$responseStream.Dispose()
