@ECHO OFF

ECHO +--------------------------------------------------+
ECHO ^|   IP2LOCATION AUTOMATED DATABASE UPDATE SCRIPT   ^|
ECHO ^|   ============================================   ^|
ECHO ^|        Website: http://www.ip2location.com       ^|
ECHO ^|        Contact: support@ip2location.com          ^|
ECHO +--------------------------------------------------+

REM SET YOUR IP2LOCATION LOGIN DETAILS BELOW
SET LOGIN=IP2LOCATION_WEBSITE_LOGIN
SET PASS=IP2LOCATION_WEBSITE_PASSWORD
SET CODE=DB24CSV
SET OUTPUTNAME=mydata.zip

SET ROOT=%~dp0
IF NOT EXIST "%ROOT%tmp" MKDIR "%ROOT%tmp"
SET DOWNLOADFOLDER=%ROOT%tmp

REM SET YOUR MYSQL LOGIN DETAILS BELOW
SET DBHOST=DATABASE_HOSTNAME
SET DBUSER=DATABASE_USERNAME
SET DBPASS=DATABASE_PASSWORD
SET DBNAME=DATABASE_NAME

REM DO NOT EDIT ANYTHING BELOW THIS LINE

IF NOT EXIST "%ROOT%download.ps1" GOTO DOWNLOADERMISSINGERROR
IF NOT EXIST "%ROOT%unzip.ps1" GOTO UNZIPMISSINGERROR

powershell -Command "set-executionpolicy unrestricted"

ECHO Downloading latest database from IP2Location website.

powershell -File download.ps1 %LOGIN% %PASS% %CODE% %OUTPUTNAME% %DOWNLOADFOLDER%

ECHO | SET /p=Download.............................................. 

IF NOT EXIST "%DOWNLOADFOLDER%\%OUTPUTNAME%" GOTO ERROR

FOR %%A IN ("%DOWNLOADFOLDER%\%OUTPUTNAME%") DO SET SIZE=%%~zA

IF %SIZE% LSS 104857600 GOTO ERROR

ECHO [OK]

ECHO | SET /p=Decompressing package................................. 

powershell -File unzip.ps1 %OUTPUTNAME% %DOWNLOADFOLDER%

IF NOT EXIST "%DOWNLOADFOLDER%\IP-COUNTRY*.CSV" GOTO ERROR

ECHO [OK]

CD %DOWNLOADFOLDER%

FOR %%c IN (IP-COUNTRY*.CSV) DO SET NAME=%%c

ECHO | SET /p=Creating temporary table in database.................. 

mysql -h %DBHOST% -u %DBUSER% -p%DBPASS% %DBNAME% -e "DROP TABLE IF EXISTS `ip2location_db24_tmp`;" 2>&1 | FINDSTR /m "ERROR" > NUL

IF %ERRORLEVEL% == 0 (GOTO MYSQLERROR)

mysql -h %DBHOST% -u %DBUSER% -p%DBPASS% %DBNAME% -e "CREATE TABLE `ip2location_db24_tmp` (`ip_from` INT(10) UNSIGNED ZEROFILL NOT NULL,`ip_to` INT(10) UNSIGNED ZEROFILL NOT NULL,`country_code` CHAR(2) NOT NULL,`country_name` VARCHAR(64) NOT NULL,`region_name` VARCHAR(128) NOT NULL,`city_name` VARCHAR(128) NOT NULL,`latitude` DOUBLE NULL DEFAULT NULL,`longitude` DOUBLE NULL DEFAULT NULL,`zip_code` VARCHAR(12) NULL DEFAULT NULL,`time_zone` VARCHAR(8) NULL DEFAULT NULL,`isp` VARCHAR(255) NOT NULL,`domain` VARCHAR(128) NOT NULL,`net_speed` VARCHAR(8) NOT NULL,`idd_code` VARCHAR(5) NOT NULL,`area_code` VARCHAR(30) NOT NULL,`weather_station_code` VARCHAR(10) NOT NULL,`weather_station_name` VARCHAR(128) NOT NULL,`mcc` VARCHAR(128) NULL DEFAULT NULL,`mnc` VARCHAR(128) NULL DEFAULT NULL,`mobile_brand` VARCHAR(128) NULL DEFAULT NULL,`elevation` INT(10) NOT NULL,`usage_type` VARCHAR(11) NOT NULL,INDEX `idx_ip_from` (`ip_from`),INDEX `idx_ip_to` (`ip_to`),INDEX `idx_isp` (`isp`)) ENGINE=MyISAM;" 2>&1 | FINDSTR /m "ERROR" > NUL

IF %ERRORLEVEL% == 0 (GOTO ERROR)

ECHO [OK]

ECHO | SET /p=Loading CSV into database............................. 

mysql -h %DBHOST% -u %DBUSER% -p%DBPASS% %DBNAME% -e "LOAD DATA LOCAL INFILE '%NAME%' INTO TABLE `ip2location_db24_tmp` FIELDS TERMINATED BY ',' ENCLOSED BY '""' LINES TERMINATED BY '\r\n';" 2>&1 | FINDSTR /m "ERROR" > NUL

IF %ERRORLEVEL% == 0 (GOTO ERROR)

ECHO [OK]

ECHO | SET /p=Dropping existing table............................... 

mysql -h %DBHOST% -u %DBUSER% -p%DBPASS% %DBNAME% -e "DROP TABLE IF EXISTS `ip2location_db24`;" 2>&1 | FINDSTR /m "ERROR" > NUL

IF %ERRORLEVEL% == 0 (GOTO ERROR)

ECHO [OK]

ECHO | SET /p=Renaming table........................................ 

mysql -h %DBHOST% -u %DBUSER% -p%DBPASS% %DBNAME% -e "RENAME TABLE `ip2location_db24_tmp` TO `ip2location_db24`;" 2>&1 | FINDSTR /m "ERROR" > NUL

IF %ERRORLEVEL% == 0 (GOTO ERROR)

ECHO [OK]

ECHO | SET /p=Performing final clean up............................. 

CD %ROOT%
RMDIR /s /q %DOWNLOADFOLDER% 

ECHO [OK]

GOTO DONE

:ERROR
ECHO [ERROR]
GOTO:EOF

:DOWNLOADERMISSINGERROR
ECHO ERROR: Missing download.ps1 file.
GOTO:EOF

:UNZIPMISSINGERROR
ECHO ERROR: Missing unzip.ps1 file.
GOTO:EOF

:MYSQLERROR
ECHO [ERROR] Please make sure your MySQL settings are correct.
GOTO:EOF

:DONE
ECHO ... [ALL DONE] ...
GOTO:EOF 