#!/bin/bash

# Configuration
TOKEN="DOWNLOAD_TOKEN"
CODE="PX4CSV"

DBHOST="YOUR_DATABASE_HOST"
DBUSER="YOUR_DATABASE_USERNAME"
DBPASS="YOUR_DATABASE_PASSWORD"
DBNAME="YOUR_DATABASE_NAME"


# ----- DO NOT EDIT ANYTHING BELOW THIS LINE ----- #

error() { echo -e "\e[91m[ERROR: $1]\e[m"; }
success() { echo -e "\e[92m$1\e[m"; }

echo "+--------------------------------------------------+"
echo "|   IP2LOCATION AUTOMATED DATABASE UPDATE SCRIPT   |"
echo "|   ============================================   |"
echo "|        Website: http://www.ip2location.com       |"
echo "|        Contact: support@ip2location.com          |"
echo "+--------------------------------------------------+"
echo ""

echo -n "Check for required commands......................... "

for a in wget unzip mysql wc find grep; do
	if [ -z "$(which $a)" ]; then
		error "Command \"$a\" not found."
		exit 0
	fi
done

success "[OK]"

if [ ! -d /tmp/ip2proxy ]; then
	echo -n "Create temporary directory.......................... "
	mkdir /tmp/ip2proxy

	if [ ! -d /tmp/ip2proxy ]; then
		error "Failed to create /tmp/ip2proxy"
		exit 0
	fi
	success "[OK]"
fi

cd /tmp/ip2proxy

echo -n "Download latest database from IP2Location website... "

wget -O database.zip -q http://www.ip2location.com/download?token=$TOKEN\&file=$CODE 2>&1

if [ ! -f database.zip ]; then
	error "Download failed."
	exit 0
fi

if [ ! -z "$(grep 'NO PERMISSION' database.zip)" ]; then
	 error "Permission denied."
        exit 0
fi

if [ ! -z "$(grep '5 times' database.zip)" ]; then
         error "Download quota exceed."
        exit 0
fi

if [ $(wc -c < database.zip) -lt 102400 ]; then
	error "Download failed."
	exit 0	
fi

success "[OK]"

echo -n "Decompress database package......................... "

unzip -q -o database.zip

if [ -z $(find . -name 'IP2PROXY*.CSV') ]; then
	echo "ERROR:"
	exit 0
fi

NAME="$(find . -name 'IP2PROXY*.CSV')"

success "[OK]"

echo -n "Create temporary table in database.................. "

RESULT="$(mysql -h $DBHOST -u $DBUSER -p$DBPASS $DBNAME -e 'DROP TABLE IF EXISTS `ip2proxy_database_tmp`;' 2>&1)"

if [ ! -z "$(echo $RESULT | grep 'connect')" ]; then
        error "Failed to connect MySQL host."
        exit 0
fi

if [ ! -z "$(echo $RESULT | grep 'Access denied')" ]; then
	error "MySQL authentication failed."
	exit 0
fi

RESULT="$(mysql -h $DBHOST -u $DBUSER -p$DBPASS $DBNAME -e 'CREATE TABLE `ip2proxy_database_tmp` (`ip_from` INT(11) UNSIGNED NOT NULL, `ip_to` INT(11) UNSIGNED NOT NULL, `proxy_type` VARCHAR(3) NOT NULL, `country_code` CHAR(2) NOT NULL, `country_name` VARCHAR(64) NOT NULL, `region_name` VARCHAR(128) NOT NULL, `city_name` VARCHAR(128) NOT NULL, `isp` VARCHAR(256) NOT NULL, INDEX `proxy_type` (`proxy_type`), INDEX `idx_ip_from` (`ip_from`), INDEX `idx_ip_to` (`ip_to`)) ENGINE=MyISAM;' 2>&1)"

if [ ! -z "$(echo $RESULT)" ]; then
	error "Unable to create temporary table."
	exit 0
fi

success "[OK]"

echo -n "Start to load CSV into database..................... "

RESULT="$(mysql -h $DBHOST -u $DBUSER -p$DBPASS $DBNAME -e 'LOAD DATA LOCAL INFILE '\'''$NAME''\'' INTO TABLE `ip2proxy_database_tmp` FIELDS TERMINATED BY '\'','\'' ENCLOSED BY '\''\"'\'' LINES TERMINATED BY '\''\r\n'\'';' 2>&1)"

if [ ! -z "$(echo $RESULT)" ]; then
        error "Failed."
        exit 0
fi

success "[OK]"

echo -n "Drop existing table................................. "

RESULT="$(mysql -h $DBHOST -u $DBUSER -p$DBPASS $DBNAME -e 'DROP TABLE IF EXISTS `ip2proxy_database`;' 2>&1)"

if [ ! -z "$(echo $RESULT)" ]; then
        error "Failed to drop \"ip2proxy_database\" table."
        exit 0
fi

success "[OK]"

echo -n "Rename table........................................ "

RESULT="$(mysql -h $DBHOST -u $DBUSER -p$DBPASS $DBNAME -e 'RENAME TABLE `ip2proxy_database_tmp` TO `ip2proxy_database`;' 2>&1)"

if [ ! -z "$(echo $RESULT)" ]; then
        error "Failed to rename table."
        exit 0
fi

success "[OK]"

echo -n "Perform final clean up.............................. "

rm -rf /tmp/ip2proxy

success "[OK]"

success "DONE: IP2Proxy database has been updated."