﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace BlockVisitorsByCountryASPDotNetMVC.Filters
{
    public class BlockVisitorsFilter : ActionFilterAttribute
    {
        private static IP2Location.Component oIP2Location = null;
        private readonly string[] BlockedCountries = { "US", "SE" };

        public override void OnActionExecuting(ActionExecutingContext filterContext)
        {
            if (oIP2Location == null)
            {
                oIP2Location = new IP2Location.Component
                {
                    IPDatabasePath = @"C:\myfolder\IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-ADDRESSTYPE-CATEGORY-DISTRICT-ASN.BIN",
                };
            }

            IP2Location.IPResult oIPResult = new IP2Location.IPResult();
            oIPResult = oIP2Location.IPQuery(filterContext.HttpContext.Request.ServerVariables["REMOTE_ADDR"]);

            if (oIPResult.Status == "OK")
            {
                if (BlockedCountries.Contains(oIPResult.CountryShort))
                {
                    filterContext.Result = new HttpStatusCodeResult(403);
                }
            }

            base.OnActionExecuting(filterContext);
        }
    }
}