﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace IP2LocationASPDotNetMVC.Controllers
{
    public class HomeController : Controller
    {
        private static IP2Location.Component oIP2Location = null;
        protected override void Initialize(System.Web.Routing.RequestContext requestContext)
        {
            if (oIP2Location == null)
            {
                oIP2Location = new IP2Location.Component
                {
                    IPDatabasePath = @"C:\Users\Kervin\Documents\Visual Studio 2012\Projects\IP2LocationComponent\IP-COUNTRY-REGION-CITY-LATITUDE-LONGITUDE-ZIPCODE-TIMEZONE-ISP-DOMAIN-NETSPEED-AREACODE-WEATHER-MOBILE-ELEVATION-USAGETYPE-ADDRESSTYPE-CATEGORY-DISTRICT-ASN.BIN"
                };
            }
            base.Initialize(requestContext);
        }

        public ActionResult Index()
        {
            return View();
        }

        public ActionResult Query()
        {
            return View();
        }

        [HttpPost]
        public ActionResult Query(Models.IPParam IPParam)
        {
            ViewBag.Message = "IP2Location query page.";

            IPParam.oIPResult = new IP2Location.IPResult();

            IPParam.oIPResult = oIP2Location.IPQuery(IPParam.IP);

            return View(IPParam);
        }

    }
}