#!/usr/bin/perl
#############################################################################################################
# IP2Proxy Converter - IP Number Ranges To IP Address Ranges
#############################################################################################################
# Description: Reads the input_file and converts the ip number to ip address and output as the below format:
#              "ip_address_from","ip_address_to","country_code","country_name"
#
# Usage: perl ip2proxy-to-ip-address-range.pl IP2PROXY-IP-COUNTRY.CSV IP2PROXY-IP-COUNTRY-NEW.CSV
#
# There is no warranty or guarantee conveyed by the author/copyright holder of
# this script. By obtaining, installing, and using this program, you agree and
# understand that the author and copyright holder are not responsible for any
# damages caused under any conditions due to the malfunction of the script(s)
# on your server or otherwise.
#
# REVISION HISTORY
# ================
# 1.0.0   Initial Release
#
# Copyright (C) 2005-2016 IP2Location.com. All rights reserved.
#
#############################################################################################################

use strict;
use Socket;
use File::Basename qw(basename);

my $script_name = basename $0;

if (($#ARGV + 1) < 2)
{
	print "\nUsage: perl $script_name [input_file] [output_file]\n";
	exit();
}

my $inputfile = $ARGV[0];
my $outputfile = $ARGV[1];

open my $in, "<", $inputfile or die "Cannot open input file";
open my $out, ">", $outputfile or die "Cannot open output file";
binmode $in;
binmode $out;

while (<$in>)
{
	my $line = $_;
	
	if ($line =~ /^"(\d+)","(\d+)"(.*)/s)
	{
		print $out '"' . &long2ip($1) . '","' . &long2ip($2) . '"' . $3;
	}
}
close $in;
close $out;

sub long2ip
{
	return inet_ntoa(pack("N*", shift));
}
